<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class CurrentCallOptions {
    /**
     * @param string $from The originating Phone Number
     * @param string $to The terminating Phone Number
     * @return FetchCurrentCallOptions Options builder
     */
    public static function fetch($from = Values::NONE, $to = Values::NONE) {
        return new FetchCurrentCallOptions($from, $to);
    }
}

class FetchCurrentCallOptions extends Options {
    /**
     * @param string $from The originating Phone Number
     * @param string $to The terminating Phone Number
     */
    public function __construct($from = Values::NONE, $to = Values::NONE) {
        $this->options['from'] = $from;
        $this->options['to'] = $to;
    }

    /**
     * The originating Phone Number, given in E.164 format (https://en.wikipedia.org/wiki/E.164). This phone number should be a Twilio number, otherwise it will return an error with HTTP Status Code 400.
     *
     * @param string $from The originating Phone Number
     * @return $this Fluent Builder
     */
    public function setFrom($from) {
        $this->options['from'] = $from;
        return $this;
    }

    /**
     * The terminating Phone Number, given in E.164 format (https://en.wikipedia.org/wiki/E.164).
     *
     * @param string $to The terminating Phone Number
     * @return $this Fluent Builder
     */
    public function setTo($to) {
        $this->options['to'] = $to;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.TrustedComms.FetchCurrentCallOptions ' . implode(' ', $options) . ']';
    }
}